USE [EleriumClean]
GO

/****** Object:  Table [dbo].[StoreItemCode]    Script Date: 10/3/2013 8:16:39 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[StoreItemCode](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[StoreItemID] [int] NOT NULL,
	[StoreOrderID] [int] NULL,
	[DateCreated] [datetime] NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[Code] [nvarchar](64) NOT NULL,
 CONSTRAINT [PK_StoreItemCode] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

ALTER TABLE [dbo].[StoreItemCode] ADD  CONSTRAINT [DF_StoreItemCode_DateCreated]  DEFAULT (getutcdate()) FOR [DateCreated]
GO

ALTER TABLE [dbo].[StoreItemCode] ADD  CONSTRAINT [DF_StoreItemCode_DateModified]  DEFAULT (getutcdate()) FOR [DateModified]
GO

ALTER TABLE [dbo].[StoreItemCode]  WITH CHECK ADD  CONSTRAINT [FK_StoreItemCode_StoreItem] FOREIGN KEY([StoreItemID])
REFERENCES [dbo].[StoreItem] ([ID])
GO

ALTER TABLE [dbo].[StoreItemCode] CHECK CONSTRAINT [FK_StoreItemCode_StoreItem]
GO

ALTER TABLE [dbo].[StoreItemCode]  WITH CHECK ADD  CONSTRAINT [FK_StoreItemCode_StoreOrder] FOREIGN KEY([StoreOrderID])
REFERENCES [dbo].[StoreOrder] ([ID])
GO

ALTER TABLE [dbo].[StoreItemCode] CHECK CONSTRAINT [FK_StoreItemCode_StoreOrder]
GO


